#include "AudioStack/clInputHelper.h"
#include "AudioStack/clAudioSMEngine.h"
#include "AudioStack/AudioSources/clAudioSource.h"

namespace AudioStack
{
using namespace AudioSource;

clInputHelper* clInputHelper::m_instance = NULL;
tU32           clInputHelper::m_value1 = 0;
tU32           clInputHelper::m_value2 = 0;

clInputHelper* clInputHelper::getInstance()
{
   if(m_instance == NULL)
   {
      m_instance = new clInputHelper();
   }
   return m_instance;
}

tVoid clInputHelper::setValues(tU32 value1, tU32 value2)
{
   m_value1 = value1;
   m_value2 = value2;
}

tVoid clInputHelper::setRunlevel()
{
   clAudioSMEngine::SetRunlevel((tU8)m_value1);
}

tVoid clInputHelper::sourceAvailable()
{
   clAudioSMEngine::Source_AvailabilityChange(SourceID((tU8)m_value1,(tU16)m_value2),
                     clAudioSource::available,
                     clAudioSource::newmedia);
}

}
